package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.sm.dto.SearchFormDTO;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessagesPage;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.web.utils.ut;
import gov.va.med.mhv.sm.dao.AddresseeDao;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MoveMessage extends AbstractInboxAction  {

	private static final Log log = LogFactory.getLog(MoveMessage.class);
	private HttpServletRequest request;
	private MailboxService mailboxService;
	private MessageService messageService;
	private AddresseeDao addresseeDao;
	private User user;
	private Folder currentFolder;
	private String msgSubmit;
	private String msgReminderDelete;
	private String removeSelected;
	private String moveMsgFolder;
	private List<String> messageChk;
	private String STRUTS_RESULT;
	private String REFRESH_INBOX="REFRESHINBOX";
	private String REFRESH_FOLDER="REFRESHFOLDER";
	private final String UNCONFIRMED_MESSAGES = "unconfirmed.messages.for.deletion";
	private final String MOVE_MSG_FOLDER = "unconfirmed.message.move.folder";
	private String searchMessageSubject;
	private String searchMessageTo;
	private String searchMessageFromDate;
	private String searchMessageToDate;
	private String searchMessages;
	private String cancelSearchMessages;
	private String searchMessageFrom;
	private String searchMessageId;
	private boolean exactMatch = false;

	public MoveMessage(){
		super();
	}

	public void setServletRequest(HttpServletRequest httpServletRequest) {
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());

		mailboxService = (MailboxService) ctx.getBean("mailboxService");
		messageService = (MessageService) ctx.getBean("messageService");
		addresseeDao = (AddresseeDao) ctx.getBean("addresseeDao");
		
		
		user = (User) request.getSession().getAttribute(CURRENT_USER);
		currentFolder = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);

		STRUTS_RESULT = user.getUserType() == UserTypeEnum.PATIENT ? "PATIENT": "CLINICIAN";
		
	}
	
	public String removeMessagesFromAlertsFolder(){
		if(messageChk == null || messageChk.size() <= 0){
			addActionError("No messages were selected to remove.");
			return STRUTS_RESULT;
		}
		if(log.isInfoEnabled()){
			log.info(">>>500RemoveMessagesFromCPRSAlerts->Selected Messages to Remove................"+messageChk);
		}
		for(String msgId : messageChk){
			Long messageId = Long.parseLong(msgId);
			messageService.updateMessageWithCPRSNotesStatus(messageId, null,null);
		}
		mailboxService.getMessages(currentFolder);
		request.getSession().setAttribute(CURRENT_FOLDER, currentFolder);		
		return STRUTS_RESULT;
	}


	private List<Addressee> getMessagesToMove(){
		
		List<Addressee> selectedMsgList = new ArrayList<Addressee>();
		
		// see if there were messages checked
		if(messageChk == null || messageChk.size() <= 0) return selectedMsgList;
		
		MessagesPage messages = currentFolder.getMessages();
		
		// see if there are messages in the current folder
		if(messages == null || messages.getElements().size() <= 0) return selectedMsgList;
		if(log.isInfoEnabled()){
			log.info(">>>500MoveMessages->Selected Messages to Move................"+messageChk);
		}	
		for(String sMsgId : messageChk){
			Long msgId = Long.parseLong(sMsgId);
			// see if we have the message in the list
			for(Addressee addsee : messages.getElements()){
				if(addsee.getMessage().getId().equals(msgId)){
					selectedMsgList.add(addsee);
					break;
				}
			}
		}
		return selectedMsgList;
	}

	
	public String moveMessages(){
		
		if(removeSelected!=null){
		
			return removeMessagesFromAlertsFolder();
		}
		
		if(msgReminderDelete !=null){
			if(messageChk == null || messageChk.size() <= 0){
				addActionError("No messages were selected to delete reminder.");
				return STRUTS_RESULT;
			}
			else{
				return deleteMessageReminders();	
			}
			
		}
		
		if(msgSubmit != null && msgSubmit.equalsIgnoreCase("Search")) 
		{
			return performSearch();
		} else if(msgSubmit != null && msgSubmit.equalsIgnoreCase("Cancel"))
		{
			request.getSession().removeAttribute(SEARCH_FORM);
			if(currentFolder.getName()==SystemFolderEnum.REASSIGN.getName()){
				request.getSession().setAttribute("SortOrder","DESC");
			}
			return REFRESH_FOLDER;
		} else if(msgSubmit != null && msgSubmit.equalsIgnoreCase("Search...")) 
		{
			//setup search by putting an empty dto in session
			if( request.getSession().getAttribute(SEARCH_FORM) == null) 
			{
				request.getSession().setAttribute(SEARCH_FORM,new SearchFormDTO());
				request.getSession().setAttribute(INVALID_SEARCH_ID,null);
			}
			return STRUTS_RESULT;
		}
		return moveMessagesInt(false);
	}
	
	public String deleteMessageReminders()
	{
		MessagesPage messages = currentFolder.getMessages();
		for(String sMsgId : messageChk)
		{
			Long msgId = Long.parseLong(sMsgId);
			for(Addressee a : messages.getElements()){
				if(a.getMessage().getId().equals(msgId)){
					messageService.deleteAddresseeReminders(a.getId());
				}
			}
		}
		mailboxService.getMessages(currentFolder);
		return STRUTS_RESULT;
	}
	
	@SuppressWarnings("unchecked")
	public String moveMessagesConfirmed(){
		
		if(msgSubmit.equals("Cancel")){
			return STRUTS_RESULT;
		}
		
		messageChk = (List<String>)request.getSession().getAttribute(UNCONFIRMED_MESSAGES);
		moveMsgFolder = (String)request.getSession().getAttribute(MOVE_MSG_FOLDER);
		return moveMessagesInt(true);
	}
	
	@SuppressWarnings("unchecked")
	private String moveMessagesInt(boolean confirmed) {
		boolean noMessagesChecked = false;
		if(msgSubmit != null && msgSubmit.equalsIgnoreCase("Delete Selected")){
			if(log.isInfoEnabled()){
				log.info("moveMessages: Delete the messages");	
			}
			moveMsgFolder = String.valueOf(SystemFolderEnum.DELETED.getId());
		}
		
		List<Addressee> messages = getMessagesToMove();
		
		if(messages == null || messages.size() == 0){
			addActionError("No messages were selected to move or delete.");
			return STRUTS_RESULT;
		}
		
		if(currentFolder.getId().equals(SystemFolderEnum.DRAFTS.getId())){
			if(moveMsgFolder.equals(SystemFolderEnum.DELETED.getId().toString())){
				// we can't delete draft messages without a confirmation
				if(!confirmed){
					request.getSession().setAttribute(UNCONFIRMED_MESSAGES, messageChk);
					request.getSession().setAttribute(MOVE_MSG_FOLDER, moveMsgFolder);
					return STRUTS_RESULT + "_CONFIRM";
				}
			}else{
				addActionError("Draft messages may be deleted but not moved.");
				return STRUTS_RESULT;
			}
		}
		
		if(isFolder()){

			for(Addressee adse : messages){
				Message m = adse.getMessage();
				
				// are we working with a draft message?
				if(m.getSentDate() == null){
					if(log.isInfoEnabled()){
						log.info("Deleting Draft Message ->Message Id:"+m.getId());
					}	
					// if the target folder is not DELETED then ignore
					// because drafts can only live in the DRAFTS folder
					// otherwise actually delete the draft
					if(moveMsgFolder.equals(SystemFolderEnum.DELETED.getId().toString())){
						if(log.isInfoEnabled()){
							log.info("deleting draft: " + m.getId());
						}	
						messageService.deleteDraft(user, m.getId());
						// reduce the count
						currentFolder.setCount(currentFolder.getCount()-1);
					}
				}else{
					if(log.isInfoEnabled()){
						log.info("Move Messages-> User:"+user+" Message Id: "+ m.getId() + " Target Folder Id:" + moveMsgFolder.toString());
					}	
					Long targetFolder = Long.valueOf(moveMsgFolder); 
					adse.setFolderId(targetFolder);
					messageService.moveMessage(adse);
					// reduce the count
					currentFolder.setCount(currentFolder.getCount()-1);
					
					// if we are moving unread messages then we need to tweak the unread counts
					if(adse.getReadDate() == null){
						currentFolder.setUnreadCount(currentFolder.getUnreadCount() - 1);
						Folder target = user.getMailbox().getFolders().get(targetFolder);
						target.setUnreadCount(target.getUnreadCount() + 1);
					}
				}
			}
			
			mailboxService.getMessages(currentFolder);
			request.getSession().setAttribute(CURRENT_FOLDER, currentFolder);
		}

		return STRUTS_RESULT;
	}

	public String deleteMyMessage() {
		try {
			Message mvMsg= (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
			Folder mvFolder = getMyFolder(SystemFolderEnum.DELETED.getId());
			messageService.moveMessage(mvMsg, user, mvFolder);
		} catch (Exception e) {
			if(log.isErrorEnabled()){
				log.error("deleteMyMessage: Exception occured while deleting message.");	
			}
			
		}
		mailboxService.getMessages(currentFolder);
		request.getSession().setAttribute(CURRENT_FOLDER, currentFolder);

		return STRUTS_RESULT;
	}

	public String moveMyMessage() {
		try {
			if(isFolder()){
				Folder mvFolder = getMyFolder(Long.valueOf(moveMsgFolder));
				Message mvMsg= (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
				messageService.moveMessage(mvMsg, user, mvFolder);
			}
		} catch (Exception e) {
			if(log.isErrorEnabled()){
				log.error("moveMyMessage: Exception occured while moving message.");
			}	
		}
		mailboxService.getMessages(currentFolder);
		request.getSession().setAttribute(CURRENT_FOLDER, currentFolder);

		return STRUTS_RESULT;
	}


	@SuppressWarnings("unchecked")
	public Boolean isFolder() {
		Folder mvFolder;
		Long key;
		Mailbox mailbox;
		Boolean isMoveFolder = false;
		Map<Long,Folder> mvFolders = new HashMap<Long,Folder>();
		mailbox=user.getMailbox();
		mvFolders=mailbox.getFolders();
		Iterator mvFoldersIter = mvFolders.keySet().iterator();

		while (mvFoldersIter.hasNext()) {
		   key = (Long)mvFoldersIter.next();
		   mvFolder = (Folder) mvFolders.get(key);
		   if (mvFolder != null) {
		      if((String.valueOf((Long)mvFolder.getId())).equals(moveMsgFolder)){
				  isMoveFolder = true;
			  }
		   }
		}
		return isMoveFolder;
	}

	@SuppressWarnings("unchecked")
	public Folder getMyFolder(Long folderId) {
		Long key;
			Folder mvFolder;
			Folder myFolder = new Folder();
			Mailbox mailbox;
			Map<Long,Folder> mvFolders = new HashMap<Long,Folder>();
			mailbox=user.getMailbox();
			mvFolders=mailbox.getFolders();
			Iterator mvFoldersIter = mvFolders.keySet().iterator();

			while (mvFoldersIter.hasNext()) {
			   	key = (Long)mvFoldersIter.next();
			   	mvFolder = (Folder) mvFolders.get(key);
			   	if((String.valueOf((Long)mvFolder.getId())).equals(String.valueOf(folderId))){
				myFolder = mvFolder;
				}

			}
			return myFolder;
	}
		
	private String performSearch() {
		//Create SearchFormBean
		SearchFormDTO sf = new SearchFormDTO();
		sf.setSubject(searchMessageSubject);
		sf.setTo(searchMessageTo);
		sf.setFrom(searchMessageFrom);
		sf.setExactMatch(exactMatch);
		String tempSearchMessageId = null;
		if(request.getParameter("searchMessageId")!=null && request.getParameter("searchMessageId").length()!=0){
			tempSearchMessageId = searchMessageId;
		}
				
		try{
			if(tempSearchMessageId!=null){
				Long messageId = Long.parseLong(searchMessageId);
				sf.setMessageId(messageId);	
			}
			request.getSession().setAttribute(INVALID_SEARCH_ID,null);
		}catch(NumberFormatException e){
			sf.setMessageId(new Long(1));
			currentFolder = ut.getActiveFolder(request);
			mailboxService.getMessages(currentFolder, MessagesPageEnum.FIRST, sf);
			request.getSession().setAttribute(INVALID_SEARCH_ID,tempSearchMessageId);
			return STRUTS_RESULT;
		}
		
		try {
			if( searchMessageFromDate != null && searchMessageFromDate.length()!=0) {
				sf.setFromDate(DateUtils.parseDateNoLeniency(searchMessageFromDate, DateUtils.ENGLISH_DATE_FORMAT));
			}
		} catch (ParseException e) {
			addActionError("Please enter a valid start value for the Date Range.");
			return STRUTS_RESULT;
		}
		
		try {
			if( searchMessageToDate != null && searchMessageToDate.length()!=0) {
				sf.setToDate(DateUtils.parseDateNoLeniency(searchMessageToDate, DateUtils.ENGLISH_DATE_FORMAT));
			}
		} catch (ParseException e) {
			addActionError("Please enter a valid end value for the Date Range.");
			return STRUTS_RESULT;
		}
		
		if( sf.getFromDate() != null && sf.getToDate()!=null && sf.getFromDate().after(sf.getToDate())) {
			addActionError("The From Date must preceed the To Date.");
			return STRUTS_RESULT;
		}
		
		currentFolder = ut.getActiveFolder(request);
		mailboxService.getMessages(currentFolder, MessagesPageEnum.FIRST, sf);
		
		request.getSession().setAttribute(SEARCH_FORM, sf);
		return STRUTS_RESULT;
	}
	
	public boolean isSelectedMessage(Long msgId){
		
		if(messageChk == null) return false;
		String s = msgId.toString();
		for(String x : messageChk){
			if (x.equals(s)) return true;
		}
		return false;
	}

	public void setMoveMsgFolder(String moveMsgFolder) {
		this.moveMsgFolder = moveMsgFolder;
	}

	public String getMoveMsgFolder() {
			return moveMsgFolder;
	}

	public void setMsgSubmit(String msgSubmit) {
		this.msgSubmit = msgSubmit;
	}

	public String getMsgSubmit() {
		return msgSubmit;
	}

	public void setMessageChk(List<String> messageChk) {
			this.messageChk = messageChk;
		}

	public List<String> getMessageChk() {
			return messageChk;
	}

	public String getSearchMessageFromDate() {
		return searchMessageFromDate;
	}

	public void setSearchMessageFromDate(String searchMessageFromDate) {
		this.searchMessageFromDate = searchMessageFromDate;
	}

	public String getSearchMessageSubject() {
		return searchMessageSubject;
	}

	public void setSearchMessageSubject(String searchMessageSubject) {
		this.searchMessageSubject = searchMessageSubject;
	}

	public String getSearchMessageTo() {
		return searchMessageTo;
	}

	public void setSearchMessageTo(String searchMessageTo) {
		this.searchMessageTo = searchMessageTo;
	}

	public String getSearchMessageToDate() {
		return searchMessageToDate;
	}

	public void setSearchMessageToDate(String searchMessageToDate) {
		this.searchMessageToDate = searchMessageToDate;
	}

	public String getCancelSearchMessages() {
		return cancelSearchMessages;
	}

	public void setCancelSearchMessages(String cancelSearchMessages) {
		this.cancelSearchMessages = cancelSearchMessages;
	}

	public String getSearchMessages() {
		return searchMessages;
	}

	public void setSearchMessages(String searchMessages) {
		this.searchMessages = searchMessages;
	}

	public String getSearchMessageFrom() {
		return searchMessageFrom;
	}

	public String getSearchMessageId() {
		return searchMessageId;
	}

	public void setSearchMessageId(String searchMessageId) {
		this.searchMessageId = searchMessageId;
	}

	public void setSearchMessageFrom(String searchMessageFrom) {
		this.searchMessageFrom = searchMessageFrom;
	}
	
	public boolean isExactMatch() {
		return exactMatch;
	}

	public void setExactMatch(boolean exactMatch) {
		this.exactMatch = exactMatch;
	}

	public String getMsgReminderDelete() {
		return msgReminderDelete;
	}

	public void setMsgReminderDelete(String msgReminderDelete) {
		this.msgReminderDelete = msgReminderDelete;
	}
	
	public String getRemoveSelected() {
		return removeSelected;
	}

	public void setRemoveSelected(String removeSelected) {
		this.removeSelected = removeSelected;
	}
	
}
